﻿<?php

//--------------------------- CRON ---------------------------------------------------------

add_action( 'init', 'ainia_setup_daily_schedule' );
function ainia_setup_daily_schedule() {
	if ( ! wp_next_scheduled( 'ainia_daily_event' ) ) {
		wp_schedule_event( time(), 'daily', 'ainia_daily_event');
	}
}

add_action( 'ainia_daily_event', 'ainia_daily_actions' );
function ainia_daily_actions() {
	$admins = get_users( array( 'role' => 'administrator'));
	$admin_user_id = $admins[0]->ID;
	add_extended_user_note($admin_user_id,"El cron ha sido llamado automáticamente.");
	ainia_import_crawler();
	ainia_send_newsletter();
}

//--------------------------- AVISAR CRAWLER CUANDO SE CREAN CATEGORIAS ------------------------------------------------------

add_action('edit_category','avisar_crawler',10,1);
add_action('create_category','avisar_crawler',10,1);
function avisar_crawler($term_id = null)
{
	$term = get_term($term_id,'category');	
  	$baseURL = get_option('ainia_push_url');
	if(!$baseURL)return;
	$cliente = 'Biopartner';
	$espanol = $term->name;
	$english = str_replace(',',' ',$term->description);
	$url = $baseURL . "?cli=" . urlencode($cliente) . "&cat=" . urlencode($term_id) . "&es=" . urlencode($espanol) . "&en=" .urlencode($english);
	$res = file_get_contents($url);	
}

add_action('delete_category','avisar_crawler_borrar',10,1);
function avisar_crawler_borrar($term_id = null)
{
	$term = get_term($term_id,'category');	
  	$baseURL = get_option('ainia_push_url');
	if(!$baseURL)return;
	$cliente = $_SERVER['HTTP_HOST'];
	$url = $baseURL . "?cli=" . urlencode($cliente) . "&cat=" . urlencode($term_id) . "&es=&en=";
	$res = file_get_contents($url);	
}


//--------------------------- NEWSLETTER ---------------------------------------------------

function ainia_send_newsletter()
{
	$cuantos_mails = 0;
	$users = get_users();
	$usuarios_enviados = "";
	foreach($users as $user)
	{		
		$cuantos = 0;
		$sent_posts = array();
		
		$period_days = intval(get_the_author_meta( 'newsletter', $user->ID ));
		$last_newsletter_date  = get_last_date_of_user_relation(  $user->ID, 'newsletter' );				
		$now = new DateTime("now +1 hours");				
		$objTimeZone = new DateTimeZone("Europe/Madrid");		
		$now->setTimezone($objTimeZone);
		$last = new DateTime($last_newsletter_date);			
		$dif = $last->diff($now);		
		$enviar = $dif->days >= $period_days && $period_days > 0 ? true : false;
		if(!$last_newsletter_date && $period_days)$enviar = true;
		
		if($enviar)
		{
			//Calcular el mensaje a enviar
			$max_days = intval(get_option('ainia_max_days'));
			$max_posts = intval(get_option('ainia_max_posts'));
		
			$mi_lectura = get_objects_of_user_relation( $user->ID, "browse") ;		
			$arcgs = array();
			$args['nopaging']=true;
			$args['post__not_in']=array();
			foreach( get_objects_of_user_relation( $user->ID, "browse") as $articulo)
			  $args['post__not_in'][]=$articulo->object_id;
				
			ob_start();	
			echo "<p style='Font-family:Trebuchet MS'><img src='".plugins_url( 'images/logo.png' , __FILE__ )."' /><br/><br/>";    
			
			echo "Boletín personalizado para ".$user->user_firstname." ".$user->user_lastname."<br/><br/>"; 
			$now = new DateTime('NOW');								
			$last_plazo = "";		
			$the_query = new WP_Query( $args ); 			
			if ( $the_query->have_posts() ) {
				while ( $the_query->have_posts()  ) {					
					$the_query->the_post();
					$day = new DateTime(get_the_date('d-m-Y'));	
					$dif = $day->diff($now);
					
					$salir = false;		
					if($max_days  && $dif->days >= $max_days)$salir=true;
					if($max_posts && $cuantos >= $max_posts)$salir=true;					
					if(is_post_in_user_categories(get_the_ID(),$user->ID) && !$salir)
					{			
						
							 if($dif->days >= 365 )$plazo="Hace más de un año";
						else if($dif->days >= 60  )$plazo="Hace más de dos meses";
						else if($dif->days >= 31  )$plazo="Hace más de un mes";
						else if($dif->days >= 14  )$plazo="Hace más de dos semanas";
						else if($dif->days >= 7   )$plazo="Hace más de una semana";
						else if($dif->days >= 3   )$plazo="Durante la última semana";
						else if($dif->days == 2   )$plazo="Anteayer";
						else if($dif->days == 1   )$plazo="Ayer";				
						else $plazo="Hoy";							
						if($plazo != $last_plazo){
							echo "<br/><strong>".$plazo."</strong><br/><br/>"; 
							$last_plazo = $plazo;
							}
						echo "<a href='".get_permalink(get_the_ID())."'>".get_the_title(get_the_ID())."</a><br/>";						
						echo esc_html( get_the_date() ).' - '; 
						echo __( 'Categorized in&#58; ', 'decode' ) . get_the_category_list(', ').'<br/><br/>';
						$sent_posts[]=get_the_ID();						
						$cuantos+=1;
					}		
				}
			} 
			wp_reset_postdata();	
			$buffer = ob_get_contents();
			ob_end_clean();	
		}
		
		if($enviar && $cuantos){
			//ENVIAR EL MAIL			
			$headers = 'From: AINIA iWatch <'.strip_tags(get_option('ainia_newsletter_email')).'>' . "\r\n";
			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=utf-8\r\n";			
			if(wp_mail($user->user_email, __('AINIA iWatch Newsletter','ainia'), $buffer, $headers))
			{
              add_extended_user_newsletter_sent($user->ID,$sent_posts);
			  $cuantos_mails+=1;
			}
			$usuarios_enviados .= $user->user_login.",";
		}
	}
	
	$admins = get_users( array( 'role' => 'administrator'));
	$admin_user_id = $admins[0]->ID;	
	if(!$usuarios_enviados)$usuarios_enviados="nadie";
	add_extended_user_note($admin_user_id,"El newsletter ha sido enviado a:".$usuarios_enviados);
	
    return $cuantos_mails;
}



//--------------------------- CRAWLER ------------------------------------------------------


function ainia_import_crawler()
{			
	$post_count = 0;
	
	$myDate = date('Y-m-d');
	$feed_url = substr(get_option('ainia_rss_url'), 0, -4)."_".$myDate.".xml";
	/* Franco!!! Para añadir la fecha a cada archivo xml
	$feed_url = get_option('ainia_rss_url');*/
	
	if(!$feed_url)return;

	add_filter( 'wp_feed_cache_transient_lifetime', 'ainia_import_feed_frequency'  );
	
	$admins = get_users( array( 'role' => 'administrator'));
	$admin_user_id = $admins[0]->ID;

	$result = ainia_import_crawler_posts($feed_url,$admin_user_id);
	
	if(is_wp_error($result))
		 $mensaje = $result->get_error_message($result->get_error_code());	
	else $mensaje = sprintf(__("%d posts imported from crawler",'ainia'),$result);
		
	add_extended_user_read_rss($admin_user_id,$mensaje);
	
	remove_filter( 'wp_feed_cache_transient_lifetime', 'ainia_import_feed_frequency' );
	
	return $result;
}

function ainia_import_feed_frequency($seconds)
{		
	return 'hourly';
}

function ainia_import_crawler_posts($url, $admin_user_id)
{
	include_once( ABSPATH . WPINC . '/feed.php' );	
	
	$max_posts = intval(get_option('ainia_max_rss'));
	
	$rss = fetch_feed( $url );
	
	$new_posts = 0;
	$existing_posts = 0;
			
	if (  is_wp_error( $rss ) ) return $rss; 
				
	$maxitems = $rss->get_item_quantity( $max_posts ); 
		
	$rss_items = $rss->get_items( 0, $max_posts );
	
	//echo "<pre>";print_r($rss_items);die("</pre>");				
					
	foreach ( $rss_items as $item )
	{
		//echo "<pre>";print_r($item);die("</pre>");
	
		$args = array(
			'post_status' => 'publish',
			'meta_key' => 'url_article',
			'meta_value' => esc_url($item->get_permalink())
		);
					
		$posts = get_posts( $args );
		
		if (count($posts)==0)
		{
			$c = $item->get_content() != "" ? $item->get_content() : $item->get_description();			
			
			$categorias=array();
			foreach ($item->get_categories() as $item_cat)
			{
				$term=get_term_by( 'name' , $item_cat->term , 'category');
				if($term)
					 $categorias[] = $term->term_id;
				else $categorias[] = wp_create_category( $item_cat->term);				
			}
			
			$fecha = $item->get_date('Y-m-d H:i:s');
							
			$new_post = array(
				'post_title'    => $item->get_title(),
				'post_content'  => strip_tags($c),
				'post_status'   => get_option("ainia_imported_status"),
				'post_author'   => $admin_user_id,
				'post_category' => $categorias,
				'comment_status'=> 'open',
				'post_date'		=> $fecha,
			);
			
			$post_id 	= wp_insert_post( $new_post );

			foreach(get_ainia_elements($item,'tag') as $elemento){
				$tag_id 	= get_term_id_or_create( $elemento , 'post_tag');
				if($tag_id) wp_set_object_terms( $post_id, $tag_id, 'post_tag', true);
				}
			
			foreach(get_ainia_elements($item,'source') as $elemento){
				$source_id 	= get_term_id_or_create( $elemento , 'fuente');
				if($source_id) wp_set_object_terms( $post_id, $source_id, 'fuente', true);
				}
				
			foreach(get_ainia_elements($item,'project') as $elemento){
				$project_id 	= get_term_id_or_create( $elemento , 'proyecto');
				if($project_id) wp_set_object_terms( $post_id, $project_id, 'proyecto', true);
				}
						
			$interests  = get_ainia_elements($item,'interest');			
			$interest 	= strval(intval($interests[0]));						
			
			
			add_post_meta( $post_id, 'url_article', esc_url($item->get_permalink()) );
			add_post_meta( $post_id, 'interes', $interest );
			add_post_meta( $post_id, 'original_date', $fecha );
									
			$new_posts+=1;			
		}
		else $existing_posts+=1;
	}		
		
	return $new_posts;
}

function get_ainia_elements($item,$element)
{
  $datos = array();
  if(isset($item->data['child']['http://www.ainia.es'][$element]))
   foreach($item->data['child']['http://www.ainia.es'][$element] as $elemento)
    $datos[]=$elemento['data'];
  
  return $datos;
}



function get_term_id_or_create($name,$taxonomy)
{
	if(!$name||!$taxonomy)return false;
	$term=term_exists( $name , $taxonomy);	
	if($term)return intval($term['term_id']);
	$new_term = wp_insert_term( $name , $taxonomy );			
	return is_wp_error($new_term) ? false : intval($new_term['term_id']);
}
